#include "tap.h"

#define ID_RBACK 0x80000110

TAP_ID( ID_RBACK );
TAP_PROGRAM_NAME("Radio/MP3 Background slide show");
TAP_AUTHOR_NAME("TOPFIELD");
TAP_DESCRIPTION("Radio/MP3 Background - Slide Show");
TAP_ETCINFO(__DATE__);

#define VIEW_TICK	500

word *decode_jpg( void *data, int count );
byte *load_jpg( char *filename, int *width, int *height );

static word *_vAddr[576];
static bool _started = FALSE;
static word _rgn;

static byte *_jpgData = NULL;
static word *_bmp = NULL, *_currentBmp = NULL;
static int _bmpWidth, _bmpHeight;
static int _width, _height;

static int  _nJpgFiles = 0;
static int  _currentJpg = 0;
static char _jpgFiles[256][100];
static int  _showX = 0, _showY = 0;
static int	_showState = -1;
static int 	_showCount = 0;

#define VIEW_W	700
#define VIEW_H	576
#define VIEW_X	0
#define VIEW_Y	0

void DrawBitmap( int x, int y, int width, int height, word *pixmap, int pw )
{
    word *p;
    word *pm = pixmap;
    int w;
    while( height-- )
    {
        p =_vAddr[y++]+x;
        w = width;
        pm = pixmap;
        while( w-- )
        {
            *p++ = *pm++;
        }
        pixmap += pw;
    }
}


void DrawBitmap_Scale( int width, int height, word *pixmap )
{
    word *p;
    int x, y, w;
	int xl = VIEW_W, yl = VIEW_H;
    int i, j;
    int yy;

    if( width>height ) {
        if( width>xl ) {
            yl = height*xl/width;
        } else {
            xl = width;
            yl = height;
        }
    } else {
        if( height>yl ) {
            xl = width*yl/height;
        } else {
            xl = width;
            yl = height;
        }
    }

	x = (VIEW_W - xl)/2;
	y = (VIEW_H - yl)/2;

	TAP_Osd_FillBox( _rgn, 0, 0, 720, 576, COLOR_Black );

	for( j=0; j<yl; j++ ) 
	{
		yy = (j*height/yl)*width;
		p = _vAddr[y+j] + x;
		for( i=0; i<xl; i++ ) 
		{
			*p++ = pixmap[ yy + i*width/xl ];
		}
	}
	
}


void RadioScreen_Anim( void )
{
	int i;
	int x, y;
	static int tick = 0;
	
	if( _jpgData == NULL )
	{
		for( i=0; i<_nJpgFiles; i++ )
		{
			_jpgData = load_jpg( _jpgFiles[_currentJpg], &_bmpWidth, &_bmpHeight );
			_currentJpg = (_currentJpg+1) % _nJpgFiles;
			if( _jpgData )
				break;
		}
	}
	else
	{
		if( _bmp == NULL )
		{
			_bmp = decode_jpg( _jpgData, 0 );
		}
	}

	if( _bmp && _showState == -1 )
	{
		_currentBmp = _bmp;
		_bmp = NULL;
	    _showX = _showY = 0;
		_showCount = 0;
		_showState = 0;
		_width = _bmpWidth;
		_height = _bmpHeight;
		tick = TAP_GetTick();
	}

	if( _currentBmp )
	{
  	    DrawBitmap_Scale( _width, _height, _currentBmp );
		TAP_MemFree( _currentBmp );
		_currentBmp = NULL;
		TAP_MemFree( _jpgData );
		_jpgData = NULL;
		tick = TAP_GetTick();
	}
	if( TAP_GetTick() >= (tick+VIEW_TICK) && _nJpgFiles > 1 )
	{
		_showState = -1;
	}
}

void RadioScreen_Start( void )
{
	int tmpRgn;
	int i, j, t;
    TYPE_OsdBaseInfo osdBaseInfo;
    
    if( _started == TRUE )
        return;
    
    _started = TRUE;

	// create osd region in OSD Plane2
    _rgn = TAP_Osd_Create( 0, 0, 720, 576, 0, OSD_Flag_Plane2 );
    TAP_Osd_GetBaseInfo( &osdBaseInfo );

	// restore osd setting for other TAP appl.
	tmpRgn = TAP_Osd_Create( 0, 0, 1, 1, 0, 0 );
	TAP_Osd_Delete( tmpRgn );

    // set OSD vertical address
    for( i=0; i<576; i+=2 )
    {
        _vAddr[i] = osdBaseInfo.eAddr + 720*i;
        _vAddr[i+1] = osdBaseInfo.oAddr + 720*i;
    }

	TAP_Osd_FillBox( _rgn, 0, 0, 720, 576, COLOR_Black );
	/*
	// draw start screen
	srand( TAP_GetTick() );
	t = rand()%360;
	if( _currentBmp == NULL )
	{
		for( j=VIEW_Y; j<VIEW_Y+VIEW_H; j++ )
		{
			int a = 0x60+TAP_Sin( 0x60, t+180+TAP_Sin(180,j) );
			for( i=VIEW_X; i<VIEW_X+VIEW_W; i++ )
			{
				int b = 0x60+TAP_Cos( 0x60, i );
				*(_vAddr[j]+i) = RGB8888( b, (a+b)>>1, a );
			}
		}
	}
	*/

    RadioScreen_Anim();
}

void RadioScreen_End( void )
{
    if( _started == FALSE )
    {
	    _rgn = TAP_Osd_Create( 0, 0, 720, 576, 0, OSD_Flag_Plane2 );
		TAP_Osd_FillBox( _rgn, 0, 0, 720, 576, COLOR_Black );
	    TAP_Osd_Delete( _rgn );		// delete 2nd plane region
        return;
    }

    _started = FALSE;
    TAP_Osd_Delete( _rgn );		// delete 2nd plane region

	free_jpg();
	
	if( _bmp )
	{
		TAP_MemFree( _bmp );
		_bmp = NULL;
	}
	if( _currentBmp )
	{
		TAP_MemFree( _currentBmp );
		_currentBmp = NULL;
	}
	if( _jpgData )
	{
		TAP_MemFree( _jpgData );
		_jpgData = NULL;
	}
	
	_showCount = 0;
	if( _showState != -1 )
		_showState = 0;

}

dword TAP_EventHandler( word event, dword param1, dword param2 )
{
    if( event == EVT_RBACK )	// Radio background change event.
    {
//		TAP_Print("Radio back event : %d\r\n", param1 );
        if( param1 == 0 )   // radio background start
        {
            RadioScreen_Start();   
        }
        ef( param1 == 1 )   // radio background end 
        {
            RadioScreen_End();
        }
	    return 0xff;		// handled by tap
    }
    ef( event == EVT_IDLE )
    {
		dword state, subState;
		TAP_GetState( &state, &subState );
        if( state == STATE_Normal && _started == TRUE )
        {
            RadioScreen_Anim();
        }
    }
    return param1;
}

bool IsJpg( char *name )
{
    static char tmp[128];

    strcpy( tmp, name );
    strlwr( tmp );
    if( strcmp( tmp + strlen(tmp) - 4, ".jpg" ) == 0 )
        return TRUE;
    else
        return FALSE;
}

int TAP_Main(void)
{
    dword i;
    dword x, y, t;
	int totalEntry;
	TYPE_File file;
	int tvRadio, chNum;
    
    srand( TAP_GetTick() );

	// find .JPG files...
	_nJpgFiles = 0;
    _currentJpg = 0;
	totalEntry = TAP_Hdd_FindFirst( &file );
	while( totalEntry-- )
	{
		if( IsJpg( file.name ) )
		{
			strcpy( _jpgFiles[_nJpgFiles++], file.name );
		}
		if( totalEntry==0 || TAP_Hdd_FindNext( &file ) == 0 )
		{
			break;
		}
	}

	_currentJpg = rand()%_nJpgFiles;

	TAP_Channel_GetCurrent( &tvRadio, &chNum );
	if( tvRadio == SVC_TYPE_Radio )
	    RadioScreen_Start();   

    return 1;	// TSR mode
}


